<?php

namespace SiteModules\WdBitcoin\Controllers;

use SiteModules\WdBitcoin\WdBitcoinModule;
use App\Models\User_account;
use App\Models\Withdrawal_method;

use App\Helpers\SiHash;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class UserAccountController extends Controller
{
    private function getWithdrawMethod()
    {
        return Withdrawal_method::where('slug', WdBitcoinModule::SLUG)->first();
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @version 1.0.0
     * @since 1.0
     */
    public function form(Request $request)
    {
       
        if ($request->ajax()) {
            $actionUrl = route('user.withdraw.account.'.WdBitcoinModule::SLUG.'.save');
            $quickAdd = $request->get('quick_added', false);
            
            $method = $this->getWithdrawMethod();
        
            $currencies = $method->currencies;
            
            return view('WdBitcoin::account-form', compact('actionUrl', 'currencies', 'quickAdd'));
        }
    }

    private function validateInput(Request $request)
    {
        return $request->validate([
            'wdm-label' => 'nullable|string',
            'wdm-email' => 'required',
            'wdm-currency' => 'nullable'
        ], [
            'wdm-email.*' => __('Enter valid bitcoin address.')
        ]);
    }

    /**
     * @param Request $request
     * @version 1.0.0
     * @since 1.0
     */
    public function save(Request $request)
    {
        $input = $this->validateInput($request);

        $name = ($input['wdm-label']) ? strip_tags($input['wdm-label']) : 'AC-'.substr(sprintf('%04s', auth()->user()->id), -4, 4).'-'.rand(1001, 9999);
        
        $config = [ 'account' => $input['wdm-email'], 'currency' => $input['wdm-currency'] ];

        $account = new User_account();
        $account->fill([
            'user_id' => auth()->user()->id,
            'slug' => WdBitcoinModule::SLUG,
            'name' => $name,
            'config' => $config
        ]);
     
        $account->save();

      
        return response()->json(['status' => true,"msg" => __('Your Bitcoin account successfully added.'), "msg_title" => __('Account Added')]);
    }

    public function edit($hash)
    {
        $id = SiHash::toID($hash);
        
        $method = $this->getWithdrawMethod();
        $currencies = $method->currencies;

        $userAccount = User_account::where('id', $id)
            ->where('user_id', auth()->user()->id)
            ->first();
        
        if (blank($userAccount)) {
            throw ValidationException::withMessages([ 'acc' => [0 => __('Invalid Account'), 1 => __('Sorry, account may invalid or not found.')] ]);
        }

        $actionUrl = route('user.withdraw.account.'.WdBitcoinModule::SLUG.'.update', ['id' => SiHash::of($id)]);
        $quickAdd = false;

        return view('WdBitcoin::account-form', compact('userAccount', 'currencies', 'actionUrl', 'quickAdd'));
    }

    public function update($hash, Request $request)
    {
        $id = SiHash::toID($hash);
        $input = $this->validateInput($request);

        $name   = strip_tags($input['wdm-label'] ?? '');
        $config = [ 'account' => $input['wdm-email'], 'currency' => $input['wdm-currency'] ];

        $account = User_account::where('id', $id)->where('slug', WdBitcoinModule::SLUG)
            ->where('user_id', auth()->user()->id)->first();

        if (blank($account)) {
            throw ValidationException::withMessages([ 'acc' => [0 => __('Invalid Account'), 1 => __('Sorry, account may invalid or not found.')] ]);
        }

        $account->update([
            'user_id' => auth()->user()->id,
            'slug' => WdBitcoinModule::SLUG,
            'name' => $name,
            'config' => $config
        ]);

        return response()->json(['status' => true, "reload" => 1500, "msg" => __($account->name .' - The Bitcoin account successfully updated.'), "msg_title" => __('Account Updated')]);
    }

    public function delete($hash)
    {
        $id = SiHash::toID($hash);
        $account = User_account::where('id', $id)->where('slug', WdBitcoinModule::SLUG)->where('user_id', auth()->user()->id)->first();

        if (blank($account)) {
           
            return redirect()->back()->with('errmessage' , '  Sorry, account may invalid or not found.');
        }

        $account->delete();

        return redirect()->back()->with('sucmessage' , $account->name.' - Bitcoin account deleted successfully');
    }
}
