<?php

use Illuminate\Support\Facades\Route;

Route::name('admin.settings.gateway.payment.')->middleware(['admin'])->prefix('admin/settings/gateway/payment-method')->group(function () {
    Route::get('/bank-deposit', 'BankSettingsController@settingsView')->name('bank-deposit');
    Route::post('/bank-deposit', 'BankSettingsController@saveBankSettings')->name('bank-deposit.save');
});

Route::middleware(['user'])->group(function () {
    Route::get('deposit-complete/bank-deposit', 'TransactionConfirmationController@depositComplete')->name('user.bank.deposit.complete');
});
